#!/bin/bash

# Read in local parameters
[ ! -e /etc/ibmc.conf ] && exit 1
. /etc/ibmc.conf

[ ${MCDEBUG} -ge 1 ] && { set -xf ; date; }
# aggressive blocking inserts deny rule while script is running. Rule deleted at end.
[ "$aggressiveBlock" == "1" ] && /sbin/ipfw add 4000 deny ip from any to any out

function setIBMCstate()
{
     ibmcStates=( local mobile )
	target_state=$1
	if [ $target_state -ne "$currentIBMCstate" ] ; then
	  echo $target_state >/bin/ibmc_im
	  currentIBMCstate=$target_state
	  process_pid=( $(ps -Ao pid,comm | grep [I]BMC) )
       [ -n "$process_pid" ] && kill -s SIGUSR1 ${process_pid[0]}
       syslog -l Alert -s "iboss Mobile setting state to ${ibmcStates[${target_state}]}"
	fi
	
}
function getIBMCstate()
{
	if [ -e /bin/ibmc_im ] ; then
	  currentIBMCstate=$(</bin/ibmc_im)
	  # if ibmc_im doesn't = 0 or 1 set to 0
	  [[ $currentIBMCstate =~ ^[01]$ ]] || setIBMCstate 0
	else
		currentIBMCstate=2 # intentionally invalid
		setIBMCstate 0
	fi
}
function validateIP()
{
# returns 0 for valid
    local testIP=$1
    local ipResult=1

    [[ $testIP =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$ ]] && ipResult=0
    return $ipResult
}
function ipToDec ()
{
# Input is dotted decimal IP, output is decimal equivalent
#IFS=.
#octet=( ${@} )
#decIP=$(( (octet[0] << 24) +  (octet[1] << 16) + (octet[2] << 8) + octet[3] ))

        IFS=.
        set $1
        decIP=$(( ((((($1*256) + $2)*256) + $3)*256) + $4 ))
        echo $decIP
	IFS=$saveIFS
}

function ipInRange ()
{
# (query IP, Start, End)
local inrange=0
        if [[ "$2" == "$3" ]] ; then    # IF start equals end
         if [[ "$1" == "$2" ]] ; then	# and query IP eq start
          inrange=1
         fi
        else		# IS Query IP between start and end
			queryIP=$(ipToDec $1)
			queryStart=$(ipToDec $2)
			queryEnd=$(ipToDec $3)
		if [ $queryStart -le $queryIP ] && [ $queryIP -le $queryEnd ] ; then
		inrange=1
		fi
        fi
echo $inrange
}

function getMyIP ()
{
# returns either valid IP or 0
myipResult="" 
myipResult=$(curl --connect-timeout 2 -s http://208.70.74.2/media/action/myip)
curlStat=$?
if [ "${curlStat}" -eq "0" ] ; then
  validateIP ${myipResult} && echo ${myipResult} || echo 0
else
  echo 0
fi
return $curlStat
}
#### END FUNCTION DEFINITIONS ####
 
saveIFS=$IFS
getIBMCstate
ipFoundInRange=0

username=$(ls -l /dev/console | awk -F'\ ' '/console/ {print $3}')
hid=$(ioreg -d 2 -k IOPlatformSerialNumber | awk '/IOPlatformSerialNumber/ { split($0, line, "\""); printf("%s", line[4]); }')
computer_name=$(scutil --get ComputerName)

echo "$username" > /bin/ibmc_un
echo "$computer_name" > /bin/ibmc_cn
echo "$hid" > /bin/ibmc_hid

lookup_result=$(getMyIP)
if [ "$lookup_result" == "0" ] ; then
# This loop is infinite until a valid address is discovered
   [ "$defaultLocal" == "1" ] && setIBMCstate 0 || setIBMCstate 1
   iter=0
   loopDelay=1
   while [ "$lookup_result" == "0" ] ; do
     sleep $loopDelay
     [ $iter -eq 30 ] && loopDelay=5	#longer delay after 30 iterations
     ((iter++))
     lookup_result=$(getMyIP)
   done 
fi
# at this point lookup_result must be a valid IP
IFS=","
found=0
for v in $outsideIps
do
   rangeStart=$(echo $v | cut -f1 -d-)
   rangeEnd=$(echo $v | cut -f2 -d-)

   ipFoundInRange=$(ipInRange $lookup_result $rangeStart $rangeEnd)

   if [ $ipFoundInRange = 1 ]; then
      found=1
      break;
   fi

done
[ "$aggressiveBlock" == "1" ] && /sbin/ipfw delete 4000
IFS=$saveIFS
if [[ $found == 1 ]]; then
   setIBMCstate 0
else
   setIBMCstate 1
fi


exit 0

