#!/bin/sh

cd $(dirname $0)
# Make sure initial configuration is done
if fgrep -q '#.#.#.#' ibmc.conf; then
	echo "============================================================================================="
	echo "!!! Configuration has not been modified with local parameters!!!"
	echo " Exiting. Modify values in ibmc.conf"
	echo "============================================================================================="
	echo " "
	exit 1
fi

echo "Removing previous installations of the iBoss Mobile Agent..."

sudo launchctl unload /Library/LaunchDaemons/iboss.mobile.reload.plist > /dev/null 2>&1
sudo launchctl unload /Library/LaunchDaemons/iboss.mobile.agent.plist > /dev/null 2>&1

sudo rm -f /bin/IBMC
sudo rm -f /bin/iboss.mobile.reload.sh
sudo rm -f /bin/iboss.mobile.agent.sh
sudo rm -f /Library/LaunchDaemons/iboss.mobile.agent.plist
sudo rm -f /Library/LaunchDaemons/iboss.mobile.reload.plist
sudo rm -f /bin/iboss.mobile.version
sudo rm -f /etc/ibmc.conf

sudo ipfw delete 1 > /dev/null 2>&1
sudo ipfw delete 2 > /dev/null 2>&1
sudo ipfw delete 3 > /dev/null 2>&1
sudo ipfw delete 4 > /dev/null 2>&1
sudo ipfw delete 5 > /dev/null 2>&1
sudo ipfw -f flush > /dev/null 2>&1
sudo ip6fw delete 50 > /dev/null 2>&1

killall IBMC >/dev/null 2>&1


echo "Installing iboss Mobile Agent"


# Extended attributes must be removed or launchd may not allow execution
sudo xattr -d  com.apple.metadata iboss* IBMC ibmc.conf    > /dev/null 2>&1
sudo xattr -d  com.apple.quarantine iboss* IBMC ibmc.conf     > /dev/null 2>&1
sudo xattr -d  com.apple.FinderInfo iboss* IBMC ibmc.conf     > /dev/null 2>&1
sudo xattr -d  com.apple.TextEncoding iboss* IBMC ibmc.conf     > /dev/null 2>&1

# The next 6 files are the ones to replicate if deploying with a management tool
sudo cp IBMC /bin/
sudo cp ibmc.conf /etc/
sudo cp iboss.mobile.agent.sh /bin/
sudo cp iboss.mobile.reload.sh /bin/
sudo cp version /bin/iboss.mobile.version
sudo cp iboss.mobile.agent.plist /Library/LaunchDaemons/
sudo cp iboss.mobile.reload.plist /Library/LaunchDaemons/

sudo chmod 700 /bin/IBMC
sudo chmod 640 /etc/ibmc.conf
sudo chmod 700 /bin/iboss.mobile.agent.sh
sudo chmod 700 /bin/iboss.mobile.reload.sh
sudo chmod 644 /bin/iboss.mobile.version
sudo chown root:wheel /bin/IBMC
sudo chown root:wheel /etc/ibmc.conf
sudo chown root:wheel /bin/iboss.mobile.agent.sh
sudo chown root:wheel /bin/iboss.mobile.reload.sh
sudo chown root:wheel /bin/iboss.mobile.version
sudo chmod 644 /Library/LaunchDaemons/iboss.mobile.agent.plist
sudo chmod 644 /Library/LaunchDaemons/iboss.mobile.reload.plist
sudo chown root:wheel /Library/LaunchDaemons/iboss.mobile.reload.plist
sudo chown root:wheel /Library/LaunchDaemons/iboss.mobile.agent.plist

sudo launchctl load /Library/LaunchDaemons/iboss.mobile.reload.plist
sudo launchctl load /Library/LaunchDaemons/iboss.mobile.agent.plist

echo "iboss Mobile Client is now installed"

