#!/bin/bash

# Read in local parameters
. /etc/ibmc.conf
[ ${MCDEBUG} -ge 2 ] && { optQuiet='' ; set -xv ; } || optQuiet='-q'

###10.9+ requires a hosts entry
osxVers=$(sw_vers -productVersion)
if [[ $osxVers =~ ^10.9.*|^10.10.* ]] && ! grep -q "^[^#].*www.google.com" /etc/hosts
then
   printf "216.239.32.20\twww.google.com\t#inserted by ibmc\n" >>/etc/hosts
   syslog -l Alert -s "iboss Mobile Starting: hosts file modified"
fi 

### Block IPv6
if [ "x$ipv6Block" == "x1" ]
then
     /sbin/ip6fw ${optQuiet} -f flush
     /sbin/ip6fw ${optQuiet} add 50 deny ipv6 from any to any
fi

/sbin/ipfw ${optQuiet} -f flush

/sbin/ipfw ${optQuiet} add divert 5500 udp from any to any 53 out
/sbin/ipfw ${optQuiet} add divert 5500 proto udp src-port 53 in

if [ "$bypassLocalAddresses" = "1" ]; then
/sbin/ipfw ${optQuiet} add allow ip from any to 192.168.0.0/16 out
/sbin/ipfw ${optQuiet} add allow ip from any to 10.0.0.0/8 out
/sbin/ipfw ${optQuiet} add allow ip from any to 172.16.0.0/12 out 
fi

/sbin/ipfw ${optQuiet} add allow ip from any to $mobileClientGatewayIp out
/sbin/ipfw ${optQuiet} add allow ip from any to $blockPageIp out
/sbin/ipfw ${optQuiet} add allow ip from any to $dnsBlockIp out
/sbin/ipfw ${optQuiet} add allow ip from any to $locatorIp out
/sbin/ipfw ${optQuiet} add 5000 divert 5500 ip from any to any out

syslog -l Alert -s "iboss Mobile Starting: ${mobileClientGatewayIp}:${mobileClientGatewayPort} $securityKey"

/bin/IBMC 5500 $blockPageIp $blockPageUrl $dnsBlockIp $locatorIp $mobileClientGatewayIp $mobileClientGatewayPort $securityKey $enableSafeSearch $cacheSize $bypassLocalAddresses $cacheExpirationSeconds $cleanImageSearchEnabled $cleanVideoSearchIp $cleanVideoSearchEnabled $highPerfCaching

